/*
 *
 *  Universal Protocol Analyzer library
 *
 *  Copyright (C) 2006-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __UPA_PACKET_H__
#define __UPA_PACKET_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define UPA_TYPE_PACKET (upa_packet_get_type())

#define UPA_PACKET(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj),UPA_TYPE_PACKET,UpaPacket))
#define UPA_PACKET_CLASS(klass) \
	(G_TYPE_CHECK_CLASS_CAST((klass),UPA_TYPE_PACKET,UpaPacketClass))
#define UPA_IS_PACKET(obj) \
	(G_TYPE_CHECK_INSTANCE_TYPE((obj),UPA_TYPE_PACKET))
#define UPA_IS_PACKET_CLASS(obj) \
	(G_TYPE_CHECK_CLASS_TYPE((klass),UPA_TYPE_PACKET))

#define UPA_PACKET_TIMESTAMP(packet) (UPA_PACKET(packet)->timestamp)

typedef struct _UpaPacket UpaPacket;
typedef struct _UpaPacketClass UpaPacketClass;

struct _UpaPacket {
	GObject parent;

	guint64 timestamp;

	gpointer head;
	gpointer data;

	gsize head_size;
	gsize data_size;

	gpointer head_area;
	gpointer data_area;

	GSList *fragments;
};

struct _UpaPacketClass {
	GObjectClass parent_class;
};

GType upa_packet_get_type(void);

UpaPacket *upa_packet_new(void);
void upa_packet_print(UpaPacket *packet);

gpointer upa_packet_alloc_head(UpaPacket *packet, gsize size);
gpointer upa_packet_alloc_data(UpaPacket *packet, gsize size);
gpointer upa_packet_alloc_data_with_head(UpaPacket *packet,
						gsize size, gsize offset);

#define upa_packet_unref(packet) g_object_unref((packet))

G_END_DECLS

#endif /* __UPA_PACKET_H__ */
