/*
 *
 *  Universal Protocol Analyzer library
 *
 *  Copyright (C) 2006-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include "upa-packet.h"

G_DEFINE_TYPE(UpaPacket, upa_packet, G_TYPE_OBJECT)

static void upa_packet_init(UpaPacket *self)
{
}

static void upa_packet_class_init(UpaPacketClass *klass)
{
}

UpaPacket *upa_packet_new(void)
{
	UpaPacket *packet;

	packet = g_object_new(UPA_TYPE_PACKET, NULL);

	return packet;
}

void upa_packet_print(UpaPacket *packet)
{
	printf("%jd [head %p size %zd] [data %p size %zd] {head %p data %p}\n",
				packet->timestamp,
				packet->head, packet->head_size,
				packet->data, packet->data_size,
				packet->head_area, packet->data_area);
}

gpointer upa_packet_alloc_head(UpaPacket *packet, gsize size)
{
	g_free(packet->head_area);

	packet->head_area = g_malloc(size);
	packet->head_size = size;
	packet->head = packet->head_area;

	return packet->head;
}

gpointer upa_packet_alloc_data(UpaPacket *packet, gsize size)
{
	g_free(packet->data_area);

	packet->data_area = g_malloc(size);
	packet->data_size = size;
	packet->data = packet->data_area;

	if (packet->head_area == NULL) {
		packet->head_size = 0;
		packet->head = packet->data_area;
	}

	return packet->data;
}

gpointer upa_packet_alloc_data_with_head(UpaPacket *packet,
						gsize size, gsize offset)
{
	g_free(packet->head_area);
	g_free(packet->data_area);

	packet->data_area = g_malloc(size);
	packet->data_size = size - offset;
	packet->data = packet->data_area + offset;

	packet->head_size = offset;
	packet->head = packet->data_area;

	return packet->head;
}
