/* cmds.c:
 *
 ****************************************************************
 * Copyright (C) 2003, 2004 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "commands/abrowse.h"
#include "commands/add-log-version.h"
#include "commands/add-pristine.h"
#include "commands/add-id.h"
#include "commands/ancestry.h"
#include "commands/ancestry-graph.h"
#include "commands/archive-fixup.h"
#include "commands/archive-meta-info.h"
#include "commands/archive-mirror.h"
#include "commands/archive-setup.h"
#include "commands/archive-snapshot.h"
#include "commands/archive-version.h"
#include "commands/branch.h"
#include "commands/branches.h"
#include "commands/build-config.h"
#include "commands/cachedrevs.h"
#include "commands/cacherev.h"
#include "commands/cache-config.h"
#include "commands/cat-archive-log.h"
#include "commands/cat-log.h"
#include "commands/categories.h"
#include "commands/cat-config.h"
#include "commands/changelog.h"
#include "commands/commit.h"
#include "commands/default-id.h"
#include "commands/delete-id.h"
#include "commands/rm.h"
#include "commands/apply-delta.h"
#include "commands/apply-changeset.h"
#include "commands/changeset.h"
#include "commands/delta.h"
#include "commands/file-diff.h"
#include "commands/file-find.h"
#include "commands/find-pristine.h"
#include "commands/get-changeset.h"
#include "commands/get.h"
#include "commands/grab.h"
#include "commands/help.h"
#include "commands/import.h"
#include "commands/export.h"
#include "commands/init-tree.h"
#include "commands/id.h"
#include "commands/join-branch.h"
#include "commands/library-add.h"
#include "commands/library-archives.h"
#include "commands/library-branches.h"
#include "commands/library-categories.h"
#include "commands/library-config.h"
#include "commands/library-file.h"
#include "commands/library-find.h"
#include "commands/library-log.h"
#include "commands/library-remove.h"
#include "commands/library-revisions.h"
#include "commands/library-versions.h"
#include "commands/lint.h"
#include "commands/lock-pristine.h"
#include "commands/lock-revision.h"
#include "commands/log-for-merge.h"
#include "commands/log.h"
#include "commands/logs.h"
#include "commands/log-versions.h"
#include "commands/archives.h"
#include "commands/pristines.h"
#include "commands/make-archive.h"
#include "commands/make-branch.h"
#include "commands/make-category.h"
#include "commands/make-log.h"
#include "commands/make-version.h"
#include "commands/merges.h"
#include "commands/move-id.h"
#include "commands/mv.h"
#include "commands/my-default-archive.h"
#include "commands/my-id.h"
#include "commands/my-revision-library.h"
#include "commands/new-merges.h"
#include "commands/parse-package-name.h"
#include "commands/rbrowse.h"
#include "commands/redo.h"
#include "commands/register-archive.h"
#include "commands/remove-log-version.h"
#include "commands/replay.h"
#include "commands/resolved.h"
#include "commands/revisions.h"
#include "commands/set-tree-version.h"
#include "commands/show-changeset.h"
#include "commands/status.h"
#include "commands/inventory.h"
#include "commands/merge.h"
#include "commands/sync-tree.h"
#include "commands/id-tagging-defaults.h"
#include "commands/id-tagging-method.h"
#include "commands/tree-id.h"
#include "commands/tree-root.h"
#include "commands/tree-version.h"
#include "commands/uncacherev.h"
#include "commands/undo.h"
#include "commands/update.h"
#include "commands/valid-package-name.h"
#include "commands/versions.h"
#include "commands/diff.h"
#include "commands/missing.h"
#include "commands/whereis-archive.h"
#include "commands/escape.h"
#include "commands/switch.h"
#include "commands/cmds.h"
#include "po/gettext.h"



struct arch_command arch_commands[] =
{
  {"help", 0, 0, 0, 0},

  {"help", arch_cmd_help, arch_cmd_help_help, 0, 0},


  {N_("User Commands"), 0, 0, 0, 0},

  {"my-id", arch_cmd_my_id, arch_cmd_my_id_help, 0, 0},
  {"", 0},
  {"my-default-archive", arch_cmd_my_default_archive, arch_cmd_my_default_archive_help, 0, 0},
  {"register-archive", arch_cmd_register_archive, arch_cmd_register_archive_help, 0, 0},
  {"whereis-archive", arch_cmd_whereis_archive, arch_cmd_whereis_archive_help, 0, 0},
  {"archives", arch_cmd_archives, arch_cmd_archives_help, 0, 0},
  {"ls-archives", arch_cmd_archives, arch_cmd_archives_help, "archives", 1},


  {N_("Project Tree Commands"), 0, 0, 0, 0},

  {"diff", arch_cmd_diff, arch_cmd_diff_help, 0, 0},
  {"init-tree", arch_cmd_init_tree, arch_cmd_init_tree_help, 0, 0},
  {"tree-id", arch_cmd_tree_id, arch_cmd_tree_id_help, 0, 0},
  {"tree-root", arch_cmd_tree_root, arch_cmd_tree_root_help, 0, 0},
  {"", 0},
  {"tree-version", arch_cmd_tree_version, arch_cmd_tree_version_help, 0, 0},
  {"set-tree-version", arch_cmd_set_tree_version, arch_cmd_set_tree_version_help, 0, 0},
  {"", 0},
  {"undo", arch_cmd_undo, arch_cmd_undo_help, 0, 0},
  {"undo-changes", arch_cmd_undo, arch_cmd_undo_help, "undo", 1},
  {"redo", arch_cmd_redo, arch_cmd_redo_help, 0, 0},
  {"redo-changes", arch_cmd_redo, arch_cmd_redo_help, "redo", 1},
  {"", 0},
  {"file-diff", arch_cmd_file_diff, arch_cmd_file_diff_help, 0, 0},
  {"file-diffs", arch_cmd_file_diff, arch_cmd_file_diff_help, "file-diff", 1},
  {"switch", arch_cmd_switch, arch_cmd_switch_help, 0, 0},

  {N_("Project Tree Inventory Commands"), 0, 0, 0, 0},

  {"inventory", arch_cmd_inventory, arch_cmd_inventory_help, 0, 0},
  {"srcfind", arch_cmd_inventory, arch_cmd_inventory_help, "inventory", 1},
  {"changes", arch_cmd_status, arch_cmd_status_help, "status", 1},
  {"status", arch_cmd_status, arch_cmd_status_help, 0, 0},
  {"lint", arch_cmd_lint, arch_cmd_lint_help, 0, 0},
  {"resolved", arch_cmd_resolved, arch_cmd_resolved_help, 0, 0},
  {"id", arch_cmd_id, arch_cmd_id_help, 0, 0},
  {"", 0},
  {"id-tagging-method", arch_cmd_id_tagging_method, arch_cmd_id_tagging_method_help, 0, 0},
  {"", 0},
  {"add-id", arch_cmd_add_id, arch_cmd_add_id_help, 0, 0},
  {"add", arch_cmd_add_id, arch_cmd_add_id_help, "add-id", 0},
  {"delete-id", arch_cmd_delete_id, arch_cmd_delete_id_help, 0, 0},
  {"delete", arch_cmd_delete_id, arch_cmd_delete_id_help, "delete-id", 0},
  {"rm", arch_cmd_rm, arch_cmd_rm_help, 0, 0},
  {"move-id", arch_cmd_move_id, arch_cmd_move_id_help, 0, 0},
  {"move", arch_cmd_move_id, arch_cmd_move_id_help, "move-id", 0},
  {"mv", arch_cmd_mv, arch_cmd_mv_help, 0, 0},
  {"explicit-default", arch_cmd_default_id, arch_cmd_default_id_help, 0, 0},
  {"default-id", arch_cmd_default_id, arch_cmd_default_id_help, "explicit-default", 0},
  {"", 0},
  {"id-tagging-defaults", arch_cmd_id_tagging_defaults, arch_cmd_id_tagging_defaults_help, 0, 0},


  {N_("Patch Set Commands"), 0, 0, 0},

  {"changeset", arch_cmd_changeset, arch_cmd_changeset_help, 0, 0},
  {"mkpatch", arch_cmd_changeset, arch_cmd_changeset_help, "changeset", 0},
  {"apply-changeset", arch_cmd_apply_changeset, arch_cmd_apply_changeset_help, 0, 0},
  {"dopatch", arch_cmd_apply_changeset, arch_cmd_apply_changeset_help, "apply-changeset", 0},
  {"do-changeset", arch_cmd_apply_changeset, arch_cmd_apply_changeset_help, "apply-changeset", 1},
  {"show-changeset", arch_cmd_show_changeset, arch_cmd_show_changeset_help, 0, 0},


  {N_("Archive Transaction Commands"), 0, 0, 0, 0},

  {"make-archive", arch_cmd_make_archive, arch_cmd_make_archive_help, 0, 0},
  {"archive-setup",  arch_cmd_archive_setup,  arch_cmd_archive_setup_help, 0, 1},
  {"make-category", arch_cmd_make_category, arch_cmd_make_category_help, 0, 1},
  {"make-branch", arch_cmd_make_branch, arch_cmd_make_branch_help, 0, 1},
  {"make-version", arch_cmd_make_version, arch_cmd_make_version_help, 0, 1},
  {"", 0},
  {"import", arch_cmd_import, arch_cmd_import_help, 0, 0},
  {"export", arch_cmd_export, arch_cmd_export_help, 0, 0},
  {"imprev", arch_cmd_import, arch_cmd_import_help, "import", 1},
  {"commit", arch_cmd_commit, arch_cmd_commit_help, 0, 0},
  {"cmtrev", arch_cmd_commit, arch_cmd_commit_help, "commit", 1},
  {"", 0},
  {"get", arch_cmd_get, arch_cmd_get_help, 0, 0},
  {"getrev", arch_cmd_get, arch_cmd_get_help, "get", 1},
  {"get-changeset", arch_cmd_get_changeset, arch_cmd_get_changeset_help, 0, 0},
  {"get-patch", arch_cmd_get_changeset, arch_cmd_get_changeset_help, "get-changeset", 1},
  {"", 0},
  {"lock-revision", arch_cmd_lock_revision, arch_cmd_lock_revision_help, 0, 0},
  {"archive-mirror", arch_cmd_archive_mirror, arch_cmd_archive_mirror_help, 0, 0},
  {"push-mirror", arch_cmd_archive_mirror, arch_cmd_archive_mirror_help, "archive-mirror", 1},


  {N_("Archive Commands"), 0, 0, 0, 0},

  {"abrowse", arch_cmd_abrowse, arch_cmd_abrowse_help, 0},
  {"rbrowse", arch_cmd_rbrowse, arch_cmd_rbrowse_help, 0},
  {"categories", arch_cmd_categories, arch_cmd_categories_help, 0, 0},
  {"branches", arch_cmd_branches, arch_cmd_branches_help, 0, 0},
  {"versions", arch_cmd_versions, arch_cmd_versions_help, 0, 0},
  {"revisions", arch_cmd_revisions, arch_cmd_revisions_help, 0, 0},
  {"ancestry", arch_cmd_ancestry, arch_cmd_ancestry_help, 0, 0},
  {"ancestry-graph", arch_cmd_ancestry_graph, arch_cmd_ancestry_graph_help, 0, 0},

  {"", 0},
  {"cat-archive-log", arch_cmd_cat_archive_log, arch_cmd_cat_archive_log_help, 0, 0},
  {"", 0},
  {"cacherev", arch_cmd_cacherev, arch_cmd_cacherev_help, 0, 0},
  {"cachedrevs", arch_cmd_cachedrevs, arch_cmd_cachedrevs_help, 0, 0},
  {"uncacherev", arch_cmd_uncacherev, arch_cmd_uncacherev_help, 0, 0},
  {"", 0},
  {"archive-meta-info", arch_cmd_archive_meta_info, arch_cmd_archive_meta_info_help, 0, 0},
  {"archive-snapshot", arch_cmd_archive_snapshot, arch_cmd_archive_snapshot_help, 0, 0},
  {"archive-version", arch_cmd_archive_version, arch_cmd_archive_version_help, 0, 0},
  {"", 0},
  {"archive-fixup", arch_cmd_archive_fixup, arch_cmd_archive_fixup_help, 0, 0},


  {N_("Patch Log Commands"), 0, 0, 0, 0},

  {"make-log", arch_cmd_make_log, arch_cmd_make_log_help, 0, 0},
  {"log-versions", arch_cmd_log_versions, arch_cmd_log_versions_help, 0, 0},
  {"add-log-version", arch_cmd_add_log_version, arch_cmd_add_log_version_help, 0, 0},
  {"remove-log-version", arch_cmd_remove_log_version, arch_cmd_remove_log_version_help, 0, 0},
  {"log", arch_cmd_log, arch_cmd_log_help, 0, 0},
  {"logs", arch_cmd_logs, arch_cmd_logs_help, 0, 0},
  {"cat-log", arch_cmd_cat_log, arch_cmd_cat_log_help, 0, 0},
  {"", 0},
  {"changelog", arch_cmd_changelog, arch_cmd_changelog_help, 0, 0},
  {"", 0},
  {"log-for-merge", arch_cmd_log_for_merge, arch_cmd_log_for_merge_help, 0, 0},
  {"merges", arch_cmd_merges, arch_cmd_merges_help, 0, 0},
  {"new-merges", arch_cmd_new_merges, arch_cmd_new_merges_help, 0, 0},


  {N_("Multi-project Configuration Commands"), 0, 0, 0, 0},

  {"build-config", arch_cmd_build_config, arch_cmd_build_config_help, 0, 0},
  {"buildcfg", arch_cmd_build_config, arch_cmd_build_config_help, "build-config", 1},
  {"cat-config", arch_cmd_cat_config, arch_cmd_cat_config_help, 0, 0},
  {"catcfg", arch_cmd_cat_config, arch_cmd_cat_config_help, "cat-config", 1},
  {"cfgcat", arch_cmd_cat_config, arch_cmd_cat_config_help, "cat-config", 1},


  {N_("Commands for Branching and Merging"), 0, 0, 0, 0},

  {"branch", arch_cmd_branch, arch_cmd_branch_help, 0, 0},
  {"merge", arch_cmd_merge, arch_cmd_merge_help, 0, 0},
  {"star-merge", arch_cmd_merge, arch_cmd_merge_help, "merge", 1},
  {"", 0},
  {"update", arch_cmd_update, arch_cmd_update_help, 0, 0},
  {"replay", arch_cmd_replay, arch_cmd_replay_help, 0, 0},
  {"apply-delta", arch_cmd_apply_delta, arch_cmd_apply_delta_help, 0, 0},
  {"delta-patch", arch_cmd_apply_delta, arch_cmd_apply_delta_help, "apply-delta", 1},
  {"deltapatch", arch_cmd_apply_delta, arch_cmd_apply_delta_help, "apply-delta", 1},
  {"missing", arch_cmd_missing, arch_cmd_missing_help, 0, 0},
  {"whats-missing", arch_cmd_missing, arch_cmd_missing_help, "missing", 1},
  {"", 0},
  {"join-branch", arch_cmd_join_branch, arch_cmd_join_branch_help, 0, 0},
  {"sync-tree", arch_cmd_sync_tree, arch_cmd_sync_tree_help, 0, 0},
  {"make-sync-tree", arch_cmd_sync_tree, arch_cmd_sync_tree_help, "sync-tree", 1},
  {"", 0},
  {"delta", arch_cmd_delta, arch_cmd_delta_help, 0, 0},
  {"revdelta", arch_cmd_delta, arch_cmd_delta_help, "delta", 1},


  {N_("Local Cache Commands"), 0, 0, 0, 0},

  {"file-find", arch_cmd_file_find, arch_cmd_file_find_help, 0, 0},
  {"", 0},
  {"pristines", arch_cmd_pristines, arch_cmd_pristines_help, 0, 0},
  {"ls-pristines", arch_cmd_pristines, arch_cmd_pristines_help, "pristines", 1},
  {"lock-pristine", arch_cmd_lock_pristine, arch_cmd_lock_pristine_help, 0, 0},
  {"add-pristine", arch_cmd_add_pristine, arch_cmd_add_pristine_help, 0, 0},
  {"find-pristine", arch_cmd_find_pristine, arch_cmd_find_pristine_help, 0, 0},


  {N_("Revision Library Commands"), 0, 0, 0},

  {"my-revision-library", arch_cmd_my_revision_library, arch_cmd_my_revision_library_help, 0, 0},
  {"library-config", arch_cmd_library_config, arch_cmd_library_config_help, 0, 0},
  {"library-find", arch_cmd_library_find, arch_cmd_library_find_help, 0, 0},
  {"library-add", arch_cmd_library_add, arch_cmd_library_add_help, 0, 0},
  {"library-remove", arch_cmd_library_remove, arch_cmd_library_remove_help, 0, 0},
  {"library-archives", arch_cmd_library_archives, arch_cmd_library_archives_help, 0, 0},
  {"library-categories", arch_cmd_library_categories, arch_cmd_library_categories_help, 0, 0},
  {"library-branches", arch_cmd_library_branches, arch_cmd_library_branches_help, 0, 0},
  {"library-versions", arch_cmd_library_versions, arch_cmd_library_versions_help, 0, 0},
  {"library-revisions", arch_cmd_library_revisions, arch_cmd_library_revisions_help, 0, 0},
  {"library-log", arch_cmd_library_log, arch_cmd_library_log_help, 0, 0},
  {"library-file", arch_cmd_library_file, arch_cmd_library_file_help, 0, 0},

  {N_("Cache Commands"), 0, 0, 0},
  {"cache-config", arch_cmd_cache_config, arch_cmd_cache_config_help, 0, 0},

  {N_("Published Revisions Commands"), 0, 0, 0},

  {"grab", arch_cmd_grab, arch_cmd_grab_help, 0, 0},



  {N_("Miscellaneous Scripting Support"), 0, 0, 0, 0},

  {"parse-package-name", arch_cmd_parse_package_name, arch_cmd_parse_package_name_help, 0, 0},
  {"valid-package-name", arch_cmd_valid_package_name, arch_cmd_valid_package_name_help, 0, 0},
  {"escape", arch_cmd_escape, arch_cmd_escape_help, 0, 0},


  {0, },
};



/* tag: Tom Lord Tue Jun 10 17:15:53 2003 (cmds.c)
 */
