/*
   Bacula® - The Network Backup Solution

   Copyright (C) 2009 Free Software Foundation Europe e.V.

   The main author of Bacula is Kern Sibbald, with contributions from
   many others, a complete list can be found in the file AUTHORS.
   This program is Free Software; you can redistribute it and/or
   modify it under the terms of version three of the GNU Affero General Public
   License as published by the Free Software Foundation and included
   in the file LICENSE.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU Affero General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.

   Bacula® is a registered trademark of Kern Sibbald.
   The licensor of Bacula is the Free Software Foundation Europe
   (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zürich,
   Switzerland, email:ftf@fsfeurope.org.
*/

#ifndef __RESTORE_H
#define __RESTORE_H

struct RESTORE_CIPHER_CTX {
   CIPHER_CONTEXT *cipher;
   uint32_t block_size;

   POOLMEM *buf;       /* Pointer to descryption buffer */
   int32_t buf_len;    /* Count of bytes currently in buf */ 
   int32_t packet_len; /* Total bytes in packet */
};

struct r_ctx {
   JCR *jcr;
   int32_t stream;
   int32_t prev_stream;
   BFILE bfd;                          /* File content */
   uint64_t fileAddr;                  /* file write address */
   uint32_t size;                      /* Size of file */
   int flags;                          /* Options for extract_data() */
   BFILE forkbfd;                      /* Alternative data stream */
   uint64_t fork_addr;                 /* Write address for alternative stream */
   intmax_t fork_size;                 /* Size of alternate stream */
   int fork_flags;                     /* Options for extract_data() */
   int32_t type;                       /* file type FT_ */
   ATTR *attr;                         /* Pointer to attributes */
   bool extract;                       /* set when extracting */

   SIGNATURE *sig;                     /* Cryptographic signature (if any) for file */
   CRYPTO_SESSION *cs;                 /* Cryptographic session data (if any) for file */
   RESTORE_CIPHER_CTX cipher_ctx;      /* Cryptographic restore context (if any) for file */
   RESTORE_CIPHER_CTX fork_cipher_ctx; /* Cryptographic restore context (if any) for alternative stream */
};

#endif
