#!/usr/bin/python

import sys
sys.path = ["../"] + sys.path

import unittest
from AptUrl import Parser

class testUrl(unittest.TestCase):
    testValues = ( ('apt:3ddesktop', {'package':'3ddesktop',
                                      'schema': 'apt'} ),
                   ('apt://3dchess', {'package':'3dchess',
                                      'schema': 'apt'} ),
                   ('apt+http://launchpad.net/~mvo/ppa?package=2vcard',
                    {'package':'2vcard', 'schema': 'apt+http',
                     'repo_url': 'http://launchpad.net/~mvo/ppa',
                     'dist': '/' } ),
                   ('apt+http://archive.canonical.com?package=acroread?dist=feisty?section=commercial',
                    {'package':'acroread', 'schema': 'apt+http',
                     'repo_url': 'http://archive.canonical.com',
                     'dist': 'feisty', 'section': ['commercial']} ),
                   ('apt+http://archive.canonical.com?package=acroread?keyfile=ppa-key',
                    {'package':'acroread', 'schema': 'apt+http',
                     'repo_url': 'http://archive.canonical.com',
                     'keyfile': 'ppa-key' }),
                   ('apt:2vcard?minver=1.0',
                    {'package':'2vcard', 'schema': 'apt',
                     'minver': '1.0' }),
                 )

    def testValidParse(self):
        for (v, e) in self.testValues:
            print "Testing: '%s'" % v
            result_list = Parser.parse(v)
            self.assertEqual(len(result_list), 1)
            for key in e:
                self.assertEqual(getattr(result_list[0],key), e[key])

if __name__ == "__main__":
    unittest.main()
