// vs_togglebutton.h			-*-c++-*-
//
//  I like having a "togglable" button which doesn't force a particular
// policy..it makes radio buttons much easier to do right.

#ifndef VS_TOGGLEBUTTON_H
#define VS_TOGGLEBUTTON_H

#include "vs_button.h"

#include <sigc++/object_slot.h>

class vs_togglebutton:public vs_button
{
  bool checked;
  char bracketl, mark, bracketr;

protected:
  void silent_set_checked(bool _checked);
  // to be used mainly to avoid emitting signals (eg, if you're trying to
  // coordinate a togglebutton with an underlying option)

public:
  vs_togglebutton(char _bracketl, char _mark, char _bracketr,
		  std::string _label, bool _checked=false)
    :vs_button(_label), checked(_checked),
     bracketl(_bracketl), mark(_mark), bracketr(_bracketr)
  {
  }

  void paint();

  bool get_checked() {return checked;}
  void set_checked(bool _checked)
  {
    if(checked!=_checked)
      do_toggle();
  }

  // named "do_toggle" to avoid typos wrt "toggled"
  void do_toggle();

  SigC::Signal0<void> toggled;
};

class vs_checkbutton:public vs_togglebutton
{
public:
  vs_checkbutton(std::string _label, bool _checked=false)
    :vs_togglebutton('[', 'X', ']', _label, _checked)
  {
    pressed.connect(slot(*this, &vs_togglebutton::do_toggle));
  }

  vs_checkbutton(char bracketr, char mark, char bracketl,
		 std::string _label, bool _checked=false)
    :vs_togglebutton(bracketr, mark, bracketl, _label, _checked)
  {
    pressed.connect(slot(*this, &vs_togglebutton::do_toggle));
  }
};

class vs_radiobutton:public vs_togglebutton
{
public:
  vs_radiobutton(std::string _label, bool _checked=false)
    :vs_togglebutton('(', '*', ')', _label, _checked)
  {
  }
};

#endif
