// cmdline_search.cc
//
//   Copyright 2004 Daniel Burrows

#include "cmdline_search.h"

#include "cmdline_common.h"

#include <aptitude.h>
#include <load_sortpolicy.h>
#include <pkg_columnizer.h>
#include <pkg_item.h>
#include <pkg_sortpolicy.h>

#include <generic/apt.h>
#include <generic/matchers.h>

#include <vscreen/config/column_definition.h>

#include <apt-pkg/error.h>
#include <apt-pkg/strutl.h>

// compare...uses the candidate version of each package.
class compare
{
  pkg_sortpolicy *s;
public:
  compare(pkg_sortpolicy *_s):s(_s) {}

  bool operator()(pkgCache::PkgIterator a, pkgCache::PkgIterator b)
  {
    pkgCache::VerIterator av=(*apt_cache_file)[a].CandidateVerIter(*apt_cache_file);
    pkgCache::VerIterator bv=(*apt_cache_file)[b].CandidateVerIter(*apt_cache_file);

    return s->compare(a, av, b, bv)<0;
  }
};

// FIXME: apt-cache does lots of tricks to make this fast.  Should I?
int cmdline_search(int argc, char *argv[], const char *status_fname,
		   string display_format, string width, std::string sort)
{
  pkg_item::pkg_columnizer::setup_columns();

  pkg_sortpolicy *s=parse_sortpolicy(sort);

  if(!s)
    {
      _error->DumpErrors();
      return -1;
    }

  compare comp(s);

  _error->DumpErrors();

  update_screen_width();

  if(!width.empty())
    {
      unsigned long tmp=screen_width;
      StrToNum(width.c_str(), tmp, width.size());
      screen_width=tmp;
    }

  column_definition_list *columns=parse_columns(display_format,
						pkg_item::pkg_columnizer::parse_column_type,
						pkg_item::pkg_columnizer::defaults);

  if(!columns)
    {
      _error->DumpErrors();
      return -1;
    }

  if(argc<=1)
    {
      fprintf(stderr, _("search: You must provide at least one search term\n"));
      delete columns;
      return -1;
    }

  OpProgress progress;

  apt_init(&progress, true, status_fname);

  if(_error->PendingError())
    {
      _error->DumpErrors();
      delete columns;
      return -1;
    }

  std::vector<pkg_matcher *> matchers;

  for(int i=1; i<argc; ++i)
    {
      pkg_matcher *m=parse_pattern(argv[i]);
      if(!m)
	{
	  while(!matchers.empty())
	    {
	      delete matchers.back();
	      matchers.pop_back();
	    }

	  _error->DumpErrors();

	  delete columns;
	  return -1;
	}

      matchers.push_back(m);
    }

  vector<pkgCache::PkgIterator> output;
  for(pkgCache::PkgIterator pkg=(*apt_cache_file)->PkgBegin();
      !pkg.end(); ++pkg)
    {
      for(std::vector<pkg_matcher *>::iterator m=matchers.begin();
	  m!=matchers.end(); ++m)
	if((*m)->matches(pkg, (*apt_cache_file)[pkg].CandidateVerIter(*apt_cache_file)))
	  output.push_back(pkg);
    }

  std::sort(output.begin(), output.end(), comp);

  for(vector<pkgCache::PkgIterator>::iterator i=output.begin();
      i!=output.end(); ++i)
    printf("%s\n",
	   pkg_item::pkg_columnizer(*i,
				    i->VersionList(),
				    *columns,
				    0).layout_columns(screen_width).c_str());

  delete columns;

  return 0;
}
