// vs_layout_item.h                                       -*-c++-*-
//
//   Copyright 2004 Daniel Burrows
//
// A bridge from the layout code to the tree code.

#ifndef VS_LAYOUT_ITEM_H
#define VS_LAYOUT_ITEM_H

#include "vs_text_layout.h"
#include "vs_treeitem.h"

class vs_layout_item:public vs_treeitem
{
  class vs_layout_line;

  typedef std::vector<vs_layout_line *> child_list;

  child_list children;
  fragment *f;
  fragment_contents lines;

  int lastw;

protected:
  class vs_layout_line:public vs_treeitem
  {
    int n;
    vs_layout_item &parent;
  public:
    vs_layout_line(int _n, vs_layout_item &_parent);

    void paint(vs_tree *win, int y, bool hierarchical);

    const char *tag() const;
    const char *label() const;
  };

  // Assumes that children.size()>0
  class levelref:public vs_tree_levelref
  {
    size_t item_num;
    const child_list &lines;

  public:
    levelref(const levelref &x);
    levelref(size_t n, const child_list &_lines);

    vs_treeitem *get_item();
    virtual void advance_next();
    virtual void return_prev();
    bool is_begin();
    bool is_end();
    levelref *clone() const;
  };

public:
  vs_layout_item(fragment *f);

  const char *tag() const;
  const char *label() const;

  void paint(vs_tree *win, int y, bool hierarchical);

  int get_normal_attr();

  levelref *begin();
  levelref *end();
  bool has_visible_children();

  chstring get_line(vs_tree *win, size_t n, int basex);

  ~vs_layout_item();
};

#endif
