// vs_layout_item.cc
//
//   Copyright 2004 Daniel Burrows

#include "vs_layout_item.h"

#include "fragment.h"
#include "vs_tree.h"

vs_layout_item::vs_layout_line::vs_layout_line(int _n, vs_layout_item &_parent)
  :vs_treeitem(false),n(_n), parent(_parent)
{
  set_depth(parent.get_depth());
}

const char *vs_layout_item::vs_layout_line::tag() const {return "";}
const char *vs_layout_item::vs_layout_line::label() const {return "";}


vs_layout_item::levelref::levelref(const levelref &x)
  :vs_tree_levelref(x), item_num(x.item_num), lines(x.lines) {}

vs_layout_item::levelref::levelref(size_t n, const child_list &_lines)
  :item_num(n), lines(_lines)
{
}

vs_treeitem *vs_layout_item::levelref::get_item()
{
  return item_num<lines.size()?lines[item_num]:lines.back();
}

void vs_layout_item::levelref::advance_next() {++item_num;}
void vs_layout_item::levelref::return_prev() {--item_num;}
bool vs_layout_item::levelref::is_begin() {return item_num==0;}
bool vs_layout_item::levelref::is_end() {return item_num>=lines.size();}

vs_layout_item::levelref *vs_layout_item::levelref::clone() const
{
  return new levelref(*this);
}



vs_layout_item::vs_layout_item(fragment *_f)
  :f(_f), lastw(0)
{
}

// These don't need to be defined (?)
const char *vs_layout_item::tag() const {return "";}
const char *vs_layout_item::label() const {return "";}

int vs_layout_item::get_normal_attr()
{
  return A_BOLD;
}

vs_layout_item::levelref *vs_layout_item::begin() {
  return (!children.empty())?new levelref(0, children):NULL;
}

vs_layout_item::levelref *vs_layout_item::end()
{
  return (!children.empty())?new levelref(children.size(), children):NULL;
}

bool vs_layout_item::has_visible_children()
{
  return !children.empty();
}

vs_layout_item::~vs_layout_item()
{
  for(child_list::iterator i=children.begin(); i!=children.end(); ++i)
    delete *i;
  delete f;
}

chstring vs_layout_item::get_line(vs_tree *win, size_t n, int basex)
{
  if(win->getmaxx()!=lastw)
    {
      // Indent it MANUALLY for now.
      lines=f->layout(win->getmaxx()-basex);
      for(child_list::iterator i=children.begin(); i!=children.end(); ++i)
	delete *i;
      children.clear();

      for(size_t i=1; i<lines.size(); ++i)
	children.push_back(new vs_layout_line(i, *this));
    }

  if(n>=lines.size())
    return lines.back();
  else
    return lines[n];
}

void vs_layout_item::vs_layout_line::paint(vs_tree *win, int y, bool hierarchical)
{
  int basex=hierarchical?2*get_depth():0;

  chstring s=parent.get_line(win, n, basex);

  win->mvaddnstr(y, 0, chstring(basex, ' ')+s, basex+s.size());
}

void vs_layout_item::paint(vs_tree *win, int y, bool hierarchical)
{
  int basex=hierarchical?2*get_depth():0;

  chstring s=get_line(win, 0, basex);

  win->mvaddnstr(y, 0, chstring(basex, ' ')+s, basex+s.size());
}

