// apt_info_tree.h    -*-c++-*-
//
//  Copyright 2000-2002 Daniel Burrows
//
//  Abstracts a tree which displays information about a particular package (and
// optionally version).  The only thing that's special about this class is
// that it can sanely restore its state after the apt cache has been flushed.
//
//  IMPORTANT NOTE: this assumes that simply deleting its root will be enough
// to avoid segfaults while the cache is not valid.  Children that need more
// assurances should connect to cache_closed themselves.  (FIXME: add a hook
// in this class to avoid spiralling numbers of signal connections?  Good or bad
// idea?)

#ifndef APT_INFO_TREE_H
#define APT_INFO_TREE_H

#include "pkg_tree.h"

#include <apt-pkg/pkgcache.h>
#include <string>

class apt_info_tree:public vs_tree
{
  std::string package, version;
  // The package that should be used as the root, and the version to use
  // Stored so we can cleanly handle list updates

  SigC::Signal2<void, const pkgCache::PkgIterator &, const pkgCache::VerIterator &> sig;
  SigC::Signal1<void, std::string> desc_sig;

  void handle_cache_close();
protected:
  void restore_state();
  virtual vs_treeitem *setup_new_root(const pkgCache::PkgIterator &pkg,
				      const pkgCache::VerIterator &ver)=0;
public:
  SigC::Signal2<void, const pkgCache::PkgIterator &, const pkgCache::VerIterator &> *get_sig() {return &sig;}
  SigC::Signal1<void, std::string> *get_desc_sig() {return &desc_sig;}

  apt_info_tree(std::string _package, std::string _version);
};

#endif



