<!--
	Alcove improvements over vanilla DocBook stylesheets.
	This only includes bugfixes and extensions that should
	eventually be merged into Norm's stylesheets.

	Please refer to this stylesheet using the following public ID:

		-//Alcove//DOCUMENT DocBook Extended Print Stylesheet//EN
-->

<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]>
<style-sheet>
  <style-specification id="print" use="docbook">
    <style-specification-body> 

;; Remarks are considered internal material, and hidden by default.
;; Use jade's -V%show-comments% to have them shown - it will print a
;; bold warning on titlepage as well.
(define %show-comments% #f)

;;
;; Changes to be abstracted
;;
;; from common/dbl1en.dsl 1.76
(define (en-label-title-sep)
  (list
   (list (normalize "abstract")		": ")
   (list (normalize "answer")		" ")
   (list (normalize "appendix")		". ")
   (list (normalize "caution")		"")
   (list (normalize "chapter")		". ")
   (list (normalize "equation")		". ")
   (list (normalize "example")		". ")
   (list (normalize "figure")		". ")
   (list (normalize "footnote")		". ")
   (list (normalize "glosssee")		": ")
   (list (normalize "glossseealso")	": ")
   (list (normalize "important")	": ")
   (list (normalize "note")		": ")
   (list (normalize "orderedlist")	". ")
   (list (normalize "part")		". ")
   (list (normalize "procedure")	". ")
   (list (normalize "prefix")		". ")
   (list (normalize "question")		" ")
   (list (normalize "refentry")		"")
   (list (normalize "reference")	". ")
   (list (normalize "refsect1")		". ")
   (list (normalize "refsect2")		". ")
   (list (normalize "refsect3")		". ")
   (list (normalize "sect1")		". ")
   (list (normalize "sect2")		". ")
   (list (normalize "sect3")		". ")
   (list (normalize "sect4")		". ")
   (list (normalize "sect5")		". ")
;;; BEGIN change
   (list (normalize "section")		"\U-2003;") ; em space
;;; END change
   (list (normalize "simplesect")	". ")
   (list (normalize "seeie")		" ")
   (list (normalize "seealsoie")	" ")
   (list (normalize "step")		". ")
   (list (normalize "table")		". ")
   (list (normalize "tip")		": ")
   (list (normalize "warning")		"")
   ))

;; from common/dbl1fr.dsl 1.76
(define (fr-label-title-sep)
  (list
   (list (normalize "abstract")		"\U-00A0;: ")
   (list (normalize "answer")		" ")
   (list (normalize "appendix")		". ")
   (list (normalize "caution")		"")
   (list (normalize "chapter")		". ")
   (list (normalize "equation")		". ")
   (list (normalize "example")		". ")
   (list (normalize "figure")		". ")
   (list (normalize "footnote")		". ")
   (list (normalize "glosssee")		"\U-00A0;: ")
   (list (normalize "glossseealso")	"\U-00A0;: ")
   (list (normalize "important")	"\U-00A0;: ")
   (list (normalize "note")		"\U-00A0;: ")
   (list (normalize "orderedlist")	". ")
   (list (normalize "part")		". ")
   (list (normalize "procedure")	". ")
   (list (normalize "prefix")		". ")
   (list (normalize "question")		" ")
   (list (normalize "refentry")		"")
   (list (normalize "reference")	". ")
   (list (normalize "refsect1")		". ")
   (list (normalize "refsect2")		". ")
   (list (normalize "refsect3")		". ")
   (list (normalize "sect1")		". ")
   (list (normalize "sect2")		". ")
   (list (normalize "sect3")		". ")
   (list (normalize "sect4")		". ")
   (list (normalize "sect5")		". ")
;;; BEGIN change
   (list (normalize "section")		"\U-2003;") ; em space
;;; END change
   (list (normalize "simplesect")	". ")
   (list (normalize "seeie")		" ")
   (list (normalize "seealsoie")	" ")
   (list (normalize "step")		". ")
   (list (normalize "table")		". ")
   (list (normalize "tip")		"\U-00A0;: ")
   (list (normalize "warning")		"")
   ))


;;
;; Generated sosofos
;;

(define ($document-version-sosofo$)
  (make sequence
    (literal (gentext-alcove-revversion))
    (literal " ")
    (literal (data (select-elements
		    (children
		     (node-list-last 
		      (select-elements
		       (children (alcove-info-node "revhistory"))
		       (normalize "revision") )))
		    (normalize "revnumber") ))) ))

(define ($document-reference-sosofo$ linebreak)
  (let ((pnum (alcove-info-node "invpartnumber")))
    (make sequence
      (literal "Rference :")
      (if linebreak
	  (make paragraph-break)
	  (literal " "))
      (if (node-list-empty? pnum)
	    (literal "N/A")
	    (literal (data pnum))))))

(define (number-of-pages-sosofo)
  ;; use element with ID="eof" for last page, or attempt to find last element
  (let ((eof-elt (element-with-id (normalize "eof"))))
    (if (node-list-empty? eof-elt)
	(element-page-number-sosofo (last-descendant-node (sgml-root-element)))
	(make link
	  destination: (idref-address (normalize "eof"))
	  (element-page-number-sosofo eof-elt)))))
;;;  (total-node-page-numbers (sgml-root-element))

(define ($pagenumber-with-total-sosofo$)
  (make sequence
    (literal (gentext-alcove-page))
    (page-number-sosofo)		; FIXME: replace with $page-number-header-footer$ when
					; possible to parametrize font-posture ?
    (literal (gentext-alcove-page-of))
    (number-of-pages-sosofo)))


;;
;; Color definitions
;;

(define rgb-color-space (color-space 
			 "ISO/IEC 10179:1996//Color-Space Family::Device RGB"))
(define color-red (color rgb-color-space 1 0 0))

;;
;; Allow PDF graphics inclusion <!-- adapted from Ian Castle <bb@looksystems.co.uk> -->
;;

;; set this to #t using 'jade -V use-eps' to allow building a .ps document
;; instead of a .pdf one
(define use-eps #f)

;; these just add pdf to the 1.71 lists, unless we want to use eps instead
;; this allows to specify both eps and pdf in the mediaobject
(define %graphic-extensions% 
  (if use-eps
      '("eps" "epsf" "gif" "tif" "tiff" "jpg" "jpeg" "png")
      '("pdf" "gif" "tif" "tiff" "jpg" "jpeg" "png")))
(define preferred-mediaobject-notations
  (if use-eps
      '("EPS" "PS" "JPG" "JPEG" "PNG" "linespecific")
      '("PDF" "JPG" "JPEG" "PNG" "linespecific")))
(define preferred-mediaobject-extensions
  (if use-eps
      '("eps" "ps" "jpg" "jpeg" "png")
      '("pdf" "jpg" "jpeg" "png")))


;;
;; L10n
;;

(define (gentext-alcove-authors)
  (case ($lang$)
    (("en") "Authors:")
    (("fr") "Auteurs :")
    (("es") "Autores:")
    (("de") "Autoren:")
    (else (error (string-append "L10N ERROR: alcove-authors: "
				$lang$)))))

(define (gentext-alcove-revversion)
  (case ($lang$)
    (("en") "Version")
    (("fr") "Version")
    (("es") "Versin")
    (("de") "Version")
    (else (error (string-append "L10N ERROR: alcove-revversion: "
				$lang$)))))

(define (gentext-alcove-revdate)
  (case ($lang$)
    (("en") "Date")
    (("fr") "Date")
    (("es") "Fecha")
    (("de") "Datum")
    (else (error (string-append "L10N ERROR: alcove-revdate: "
				$lang$)))))

(define (gentext-alcove-revdesc)
  (case ($lang$)
    (("en") "Revision description")
    (("fr") "Objet de la rvision")
    (("es") "Descripcin de la revisin")
    (("de") "Gegenstand der berarbeitung")
    (else (error (string-append "L10N ERROR: alcove-revdesc: "
				$lang$)))))

(define (gentext-alcove-visa)
  (case ($lang$)
    (("en") "Visa")
    (("fr") "Visa")
    (("es") "Firma")
    (("de") "Unterschrift")
    (else (error (string-append "L10N ERROR: alcove-visa: "
				$lang$)))))

(define (gentext-alcove-name)
  (case ($lang$)
    (("en") "Name")
    (("fr") "Nom")
    (("es") "Nombre")
    (("de") "Name")
    (else (error (string-append "L10N ERROR: alcove-name: "
				$lang$)))))

(define (gentext-alcove-writing)
  (case ($lang$)
    (("en") "Writing")
    (("fr") "Rdaction")
    (("es") "Redaccin")
    (("de") "Bearbeitung")
    (else (error (string-append "L10N ERROR: alcove-writing: "
				$lang$)))))

(define (gentext-alcove-checking)
  (case ($lang$)
    (("en") "Checking")
    (("fr") "Vrification")
    (("es") "Revisin")
    (("de") "Prfung")
    (else (error (string-append "L10N ERROR: alcove-checking: "
				$lang$)))))

(define (gentext-alcove-approval)
  (case ($lang$)
    (("en") "Approval")
    (("fr") "Approbation")
    (("es") "Aprobacin")
    (("de") "Freigabe")
    (else (error (string-append "L10N ERROR: alcove-approval: "
				$lang$)))))

(define (gentext-alcove-page)
  (case ($lang$)
    (("en") "Page ")
    (("fr") "Page ")
;;;    (("es") "")
    (("de") "Seite ")
    (else (error (string-append "L10N ERROR: alcove-page: "
				$lang$)))))

(define (gentext-alcove-page-of)
  (case ($lang$)
    (("en") " of ")
    (("fr") " sur ")
;;;    (("es") "")
    (("de") " von ")
    (else (error (string-append "L10N ERROR: alcove-page-of: "
				$lang$)))))

;;
;; Function library
;;

(define (last-descendant-node nd)
  (if (node-list-empty? (children nd))
      nd
      (last-descendant-node (node-list-last (children nd)))))      

(define (alcove-info-node gi)
  (select-elements
   (children (select-elements
	      (children (sgml-root-element))
	      (normalize "articleinfo")))
   (normalize gi)))

;;
;;
;;

(define (%revhistory-hook%)
  (empty-sosofo))

(define %revhistory-border%
  (make table-border
    border-present?: #t
    line-thickness: 3pt
    ))

(define ($signature-box$)
  (make sequence
    (make paragraph
      space-before: 1cm
      (literal "\no-break-space;"))
    (make table
;;;    space-before: 1cm
      cell-before-row-margin: (* 0.1 %bf-size%)
      cell-after-row-margin: (* 0.3 %bf-size%)
      table-border: %revhistory-border%
      cell-after-row-border: %revhistory-border%
      cell-after-column-border: #t

      (make table-column width: (* 0.25 %text-width%))
      (make table-column width: (* 0.25 %text-width%))
      (make table-column width: (* 0.25 %text-width%))
      (make table-column width: (* 0.25 %text-width%))

      (make table-row
	(make table-cell
	  column-number: 2
	  (make paragraph
	    quadding: 'center
	    (literal (gentext-alcove-writing))))
	(make table-cell
	  (make paragraph
	    quadding: 'center
	    (literal (gentext-alcove-checking))))
	(make table-cell
	  (make paragraph
	    quadding: 'center
	    (literal (gentext-alcove-approval))))
	)
      (make table-row
	(make table-cell
	  cell-before-row-margin: %bf-size%
	  cell-after-row-margin: %bf-size%

	  (make paragraph
	    quadding: 'center
	    (literal (gentext-alcove-name)))))
      (make table-row
	(make table-cell
	  cell-before-row-margin: %bf-size%
	  cell-after-row-margin: %bf-size%

	  (make paragraph
	    quadding: 'center
	    (literal (gentext-alcove-visa)))))
      )))

(define ($revhistory-table$)
  (make sequence
    (make paragraph
      use: article-titlepage-verso-style
      font-family-name: %title-font-family%
      font-weight: 'bold
      space-before: (* (HSIZE 3) %head-before-factor%)
      space-after: (/ (* (HSIZE 1) %head-before-factor%) 2)
      (literal (gentext-element-name (current-node))))
    (make table
      table-border: #t
      cell-after-row-border: #t
      cell-after-column-border: #t
      cell-before-row-margin: (* 0.1 %bf-size%)
      cell-after-row-margin: (* 0.3 %bf-size%)
      cell-before-column-margin: (* 0.2 %bf-size%)
      cell-after-column-margin: (* 0.2 %bf-size%)

      (make table-column width: (* 0.1 %text-width%))
      (make table-column width: (* 0.15 %text-width%))
      (make table-column width: (* 0.75 %text-width%))

      (make table-row
	font-weight: 'bold
	(make table-cell (make paragraph
			   quadding: 'center
			   (literal (gentext-alcove-revversion))))
	(make table-cell (make paragraph 
			   quadding: 'center
			   (literal (gentext-alcove-revdate))))
	(make table-cell (make paragraph 
			   quadding: 'center
			   (literal (gentext-alcove-revdesc))))
	)
      (process-children))
    (%revhistory-hook%)))
  
(define ($revhistory-table-revision$)
    (let ((revnumber (select-elements (descendants (current-node)) 
                                      (normalize "revnumber")))
          (revdate   (select-elements (descendants (current-node)) 
                                      (normalize "date")))
;	  (revauthor (select-elements (descendants (current-node))
;                                      (normalize "authorinitials")))
          (revremark (select-elements (descendants (current-node))
                                      (normalize "revremark"))))
      (make table-row
;	cell-after-row-border: #t
	(make table-cell
	  column-number: 1
	  n-columns-spanned: 1
	  n-rows-spanned: 1
;	  start-indent: 0pt
	  (if (node-list-empty? revnumber)
	      (empty-sosofo)
	      (make paragraph
		use: article-titlepage-verso-style
		font-size: %bf-size%
		space-after: %bf-size%
		font-weight: 'medium
		quadding: 'center
;		(literal (gentext-element-name-space (current-node)))
		(process-node-list revnumber))))

	(make table-cell
	  column-number: 2
	  n-columns-spanned: 1
	  n-rows-spanned: 1
;	  start-indent: 0pt
	  cell-before-column-margin: (if (equal? (print-backend) 'tex)
					 6pt
					 0pt)
	  (if (node-list-empty? revdate)
	      (empty-sosofo)
	      (make paragraph
		use: article-titlepage-verso-style
		font-size: %bf-size%
		font-weight: 'medium
		quadding: 'center
		(process-node-list revdate))))

	(make table-cell
	  column-number: 3
	  n-columns-spanned: 1
	  n-rows-spanned: 1
;	  start-indent: 0pt
	  (if (not (node-list-empty? revremark))
	      (make paragraph
		use: article-titlepage-verso-style
		font-size: %bf-size%
		font-weight: 'medium
		quadding: 'justify
		space-after: (if (last-sibling?) 
				 0pt
				 (/ %block-sep% 2))
		(process-node-list revremark))
	      (empty-sosofo))))))

;;
;; Admonitions
;;

(define %admon-graphics-path% "/usr/lib/sgml/stylesheet/dsssl/docbook/nwalsh/images/")
(define admon-graphic-default-extension
  (if use-eps ".eps" ".pdf"))

;; <!-- This code by Richard Sharpe <rsharpe@ns.aus.com> -->
;; Taken from http://lists.oasis-open.org/archives/docbook-apps/200107/msg00278.html
(define ($graphical-admonition$)
  (let* ((adm       (current-node))
	 (title     (select-elements (children adm)
				     (normalize "title")))
	 (title?    (not (node-list-empty? title)))
	 (adm-title (if title?
			(with-mode title-sosofo-mode
			  (process-node-list (node-list-first title)))
			(literal (gentext-element-name adm))))
	 (graphic   (make external-graphic
		      display?: #f
		      position-point-y: (+ %bf-size% 2pt)
		      entity-system-id: ($admon-graphic$)))
	 (f-child   (node-list-first (children (current-node))))
	 (r-child   (node-list-rest (children (current-node)))))

    (make table
      space-before: %block-sep%
      space-after: %block-sep%
      table-width: (- %text-width% (inherited-start-indent))
      (make table-column
	width: ($admon-graphic-width$))
      (make table-column
	width: 10pt)
      (make table-column
	width: (- %text-width%
		  (+ (inherited-start-indent)
		     ($admon-graphic-width$)
		     10pt)))
      (make table-row
	(make table-cell
	  graphic)
	(make table-cell
	  (make line-field
	    field-width: 5pt
	    field-align: 'center
	    (empty-sosofo)))
	(make table-cell
	  (make sequence
	    font-family-name: %title-font-family%
	    font-weight: 'bold
	    adm-title)
	  (process-children))))))


;;; START integrated in my 1.75-0.potato1 and later
;;
;; Don't start a block element for itemizedlist or orderedlist title
;; just inside a listitem, so that it looks correct
;;

(element (listitem itemizedlist title)
  (make sequence
    use: title-style
    (process-children)))
(element (listitem orderedlist title)
  (make sequence
    use: title-style
    (process-children)))

;; put the title itself outside the displaygroup for the same reason
(define ($list$)
  (make sequence
    (process-node-list 
     (select-elements (children (current-node))
		      (normalize "title")))
    (make display-group
      start-indent: (if (INBLOCK?)
			(inherited-start-indent)
			(+ %block-start-indent% (inherited-start-indent)))
      space-after:  (if (INLIST?) %para-sep% %block-sep%)

      (process-node-list (node-list-filter-by-not-gi
			  (children (current-node))
			  (list (normalize "title")))))))
;;; END integrated in my 1.75-0.potato1

;;;
;;; Modified code from docbook-dsssl 1.76
;;;

;; emulate vanilla behaviour using new features

(define ($section-title-quadding$) %section-title-quadding%)
(define ($section-start-indent$ hlevel)
  (if (or (>= hlevel 3)
	  (member (gi) (list (normalize "refsynopsisdiv") 
			     (normalize "refsect1") 
			     (normalize "refsect2") 
			     (normalize "refsect3"))))
      %body-start-indent%
      0pt))
(define $sidebar-start-indent$ inherited-start-indent)
(define $sidebar-end-indent$ inherited-end-indent)
(define %article-section-starts-new-page% #f)
(define %endnotes-on-own-page% #f)
(define ($endnotes-left-footer$) ($left-footer$))
(define ($endnotes-right-footer$) ($right-footer$))
(define ($endnotes-center-footer$) ($center-footer$))

(define (%titlepage-left-header%) (empty-sosofo))
(define (%titlepage-right-header%) (empty-sosofo))
(define (%titlepage-center-header%) (empty-sosofo))

(define (%titlepage-left-footer%) (empty-sosofo))
(define (%titlepage-right-footer%) (empty-sosofo))
(define (%titlepage-center-footer%) (empty-sosofo))


;; the code

;; from print/dbcompon.dsl 1.76
(element article
  (let* ((info (node-list-filter-by-gi (children (current-node))
                                       (list (normalize "artheader")
                                             (normalize "articleinfo"))))
         (nl   (titlepage-info-elements (current-node) info))
         (article-titlepage (if %generate-article-titlepage-on-separate-page%
                                (make sequence
                                  (if (article-titlepage-content? nl 'recto)
                                      (make simple-page-sequence
                                        page-n-columns: %page-n-columns%
                                        use: default-text-style
                                        quadding: %default-quadding%
;; BEGIN ADDITION
					center-header: (%titlepage-center-header%)
					left-header: (%titlepage-left-header%)
					right-header: (%titlepage-right-header%)
					center-footer: (%titlepage-center-footer%)
					left-footer: (%titlepage-left-footer%)
					right-footer: (%titlepage-right-footer%)
;; END ADDITION
                                        (article-titlepage nl 'recto))
                                      (empty-sosofo))
                                  (if (article-titlepage-content? nl 'verso)
                                      (make simple-page-sequence
                                        page-n-columns: %page-n-columns%
                                        use: default-text-style
                                        quadding: %default-quadding%
;; BEGIN ADDITION
					center-header: (%titlepage-center-header%)
					left-header: (%titlepage-left-header%)
					right-header: (%titlepage-right-header%)
					center-footer: (%titlepage-center-footer%)
					left-footer: (%titlepage-left-footer%)
					right-footer: (%titlepage-right-footer%)
;; END ADDITION
					(article-titlepage nl 'verso))
				      (empty-sosofo)))
				(make sequence
				  (article-titlepage nl 'recto)
				  (article-titlepage nl 'verso)))))
    (make sequence
      (if (and %generate-article-titlepage% 
	       %generate-article-titlepage-on-separate-page%)
	  article-titlepage
	  (empty-sosofo))

      (if (and %generate-article-toc% 
	       (not %generate-article-toc-on-titlepage%)
	       %generate-article-titlepage-on-separate-page%
	       (generate-toc-in-front))
	  (make simple-page-sequence
	    page-n-columns: %page-n-columns%
	    page-number-restart?: %article-page-number-restart%
	    page-number-format: ($page-number-format$ (normalize "toc"))
	    left-header:   ($left-header$ (normalize "toc"))
	    center-header: ($center-header$ (normalize "toc"))
	    right-header:  ($right-header$ (normalize "toc"))
	    left-footer:   ($left-footer$ (normalize "toc"))
	    center-footer: ($center-footer$ (normalize "toc"))
	    right-footer:  ($right-footer$ (normalize "toc"))
	    input-whitespace-treatment: 'collapse
	    use: default-text-style
	    quadding: %default-quadding%
	    (build-toc (current-node)
		       (toc-depth (current-node))))
	  (empty-sosofo))

;; BEGIN ADDITION	   
      (if %article-section-starts-new-page%
	  (make sequence
	    (process-children)
	    (make-endnotes))
;;; END ADDITION

	  (make simple-page-sequence
;; BEGIN ADDITION	   
	    ;; WARNING: all this is copied in ($maybe-paged-section$) below
;;; END ADDITION
	    page-n-columns: %page-n-columns%
	    page-number-restart?: (or %article-page-number-restart% 
				      (book-start?))
	    page-number-format: ($page-number-format$)
	    use: default-text-style
	    left-header:   ($left-header$)
	    center-header: ($center-header$)
	    right-header:  ($right-header$)
	    left-footer:   ($left-footer$)
	    center-footer: ($center-footer$)
	    right-footer:  ($right-footer$)
	    start-indent: %body-start-indent%
	    input-whitespace-treatment: 'collapse
	    quadding: %default-quadding%

	    (if (and %generate-article-titlepage% 
		     (not %generate-article-titlepage-on-separate-page%))
		article-titlepage
		(empty-sosofo))

	    (if (and %generate-article-toc% 
		     (generate-toc-in-front)
		     (not %generate-article-toc-on-titlepage%)
		     (not %generate-article-titlepage-on-separate-page%))
		(make display-group
		  space-after: (* (HSIZE 3) %head-after-factor%)
		  (build-toc (current-node)
			     (toc-depth (current-node))))
		(empty-sosofo))

	    (process-children)

;;; BEGIN ADDITION
	    (if %endnotes-on-own-page%
		(empty-sosofo)
;;; END ADDITION
		(make-endnotes))

	    (if (and %generate-article-toc% 
		     (not (generate-toc-in-front))
		     (not %generate-article-toc-on-titlepage%)
		     (not %generate-article-titlepage-on-separate-page%))
		(make display-group
		  space-after: (* (HSIZE 3) %head-after-factor%)
		  (build-toc (current-node)
			     (toc-depth (current-node))))
		(empty-sosofo))))

;;; BEGIN ADDITION
      (if %endnotes-on-own-page%

	  (make simple-page-sequence
	    page-n-columns: %page-n-columns%
	    page-number-restart?: (or %article-page-number-restart% 
				      (book-start?))
	    page-number-format: ($page-number-format$)
	    use: default-text-style
	    left-header:   ($left-header$)
	    center-header: ($center-header$)
	    right-header:  ($right-header$)
	    left-footer:   ($endnotes-left-footer$)
	    center-footer: ($endnotes-center-footer$)
	    right-footer:  ($endnotes-right-footer$)
	    start-indent: %body-start-indent%
	    input-whitespace-treatment: 'collapse
	    quadding: %default-quadding%

	    (make-endnotes))
	  (empty-sosofo))
;;; END ADDITION

      (if (and %generate-article-toc% 
	       (not %generate-article-toc-on-titlepage%)
	       %generate-article-titlepage-on-separate-page%
	       (not (generate-toc-in-front)))
	  (make simple-page-sequence
	    page-n-columns: %page-n-columns%
	    use: default-text-style
	    quadding: %default-quadding%
	    (build-toc (current-node)
		       (toc-depth (current-node))))
	  (empty-sosofo)))))

(define (is-section-level-element nd)
  (let ((ngi (gi nd)))
    (or (string=? ngi (normalize "section"))
	(string=? ngi (normalize "appendix")))))

(element section ($maybe-paged-section$))
(element (article appendix) ($maybe-paged-section$))
(element (article glossary) ($maybe-paged-section$))

;; FIXME: 
(define ($maybe-paged-section$)
  (if (and %article-section-starts-new-page%
	   (not (is-section-level-element (parent (current-node)))))
      (make simple-page-sequence
	;; WARNING: all this is copied from the page-seq above
	page-n-columns: %page-n-columns%
	page-number-restart?: (or %article-page-number-restart% 
				  (book-start?))
	page-number-format: ($page-number-format$)
	use: default-text-style
	left-header:   ($left-header$)
	center-header: ($center-header$)
	right-header:  ($right-header$)
	left-footer:   ($left-footer$)
	center-footer: ($center-footer$)
	right-footer:  ($right-footer$)
	start-indent: %body-start-indent%
	input-whitespace-treatment: 'collapse
	quadding: %default-quadding%

	($section$))
      ($section$)))

;; from print/dbsect.dsl 1.76
(define ($section-title$)
  (let* ((sect (current-node))
	 (info (info-element))
	 (exp-children (if (node-list-empty? info)
			   (empty-node-list)
			   (expand-children (children info) 
					    (list (normalize "bookbiblio") 
						  (normalize "bibliomisc")
						  (normalize "biblioset")))))
	 (parent-titles (select-elements (children sect) (normalize "title")))
	 (info-titles   (select-elements exp-children (normalize "title")))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children (normalize "subtitle")))
	 (renderas (inherited-attribute-string (normalize "renderas") sect))
	 (hlevel
	  ;; if not real section level, then get the apparent level
	  ;; from "renderas"
	  (if renderas
	      (section-level-by-gi #f (normalize renderas))
	      ;; else use the real level
;;; BEGIN CHANGE
	      (if (have-ancestor? "appendix" (current-node))
		  (+ 1 (SECTLEVEL))
		  (SECTLEVEL)) ))
;;; END CHANGE
	 (hs (HSIZE (- 4 hlevel))))
    (make sequence
      (make paragraph
	font-family-name: %title-font-family%
	font-weight:  (if (< hlevel 5) 'bold 'medium)
	font-posture: (if (< hlevel 5) 'upright 'italic)
	font-size: hs
	line-spacing: (* hs %line-spacing-factor%)
	space-before: (* hs %head-before-factor%)
	space-after: (if (node-list-empty? subtitles)
			 (* hs %head-after-factor%)
			 0pt)
;;; BEGIN CHANGE
	start-indent: ($section-start-indent$ hlevel)
;;; END CHANGE
	first-line-start-indent: 0pt
;;; BEGIN CHANGE
	quadding: ($section-title-quadding$)
;;; END CHANGE
	keep-with-next?: #t
	heading-level: (if %generate-heading-level% hlevel 0)
	;; SimpleSects are never AUTO numbered...they aren't hierarchical
	(if (string=? (element-label (current-node)) "")
	    (empty-sosofo)
	    (literal (element-label (current-node)) 
		     (gentext-label-title-sep (gi sect))))
	(element-title-sosofo (current-node)))
      (with-mode section-title-mode
	(process-node-list subtitles))
      ($section-info$ info))))

;; from print/dbblock.dsl 1.76
(element sidebar 
  (make box
    display?: #t
    box-type: 'border
    line-thickness: 1pt
;; BEGIN CHANGED
    start-indent: ($sidebar-start-indent$)
    end-indent: ($sidebar-end-indent$)
;; END CHANGED
    (if (node-list-empty? (select-elements (children (current-node))
					   (normalize "title")))
	(make display-group
	  start-indent: 2pt
	  end-indent: 2pt
	  space-before: %block-sep%
	  space-after: %block-sep%
	  (process-children))
	(make display-group
	  start-indent: 2pt
	  end-indent: 2pt
	  space-before: 0pt
	  space-after: %block-sep%
	  (make sequence
	    (let* ((object (current-node))
		   (title  (select-elements (children object) 
					    (normalize "title")))
		   (nsep   (gentext-label-title-sep (gi object))))
	      (make paragraph
		font-weight: 'bold
		space-before: %block-sep%
		space-after: %para-sep%
		keep-with-next?: #t
		(literal (gentext-element-name object))
		(if (string=? (element-label object) "")
		    (literal nsep)
		    (literal " " (element-label object) nsep))
		(process-node-list (children title))))
	    (process-children))))))

;; prevent glosslists to clutter pdf outlines
;; code adapted from 1.76's ($lowtitlewithsosofo$)
(element (glosslist glossentry glossterm)
  (let ((hs (HSIZE 0)))
    (make paragraph
          font-family-name: %title-font-family%
          font-weight: 'bold
          font-size: hs
          line-spacing: (* hs %line-spacing-factor%)
          space-before: (* hs %head-before-factor%)
          space-after: (* hs %head-after-factor%)
          start-indent: %body-start-indent%
          quadding: 'start
          keep-with-next?: #t
          (process-children))))

    </style-specification-body>
  </style-specification>

  <external-specification id="docbook" document="docbook.dsl">
</style-sheet>
