/* -*- C++ -*- libapt/tagfilter.h
   written by Peter Rockai <me@mornfall.net> */

#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>

#include <tagcoll/InputMerger.h>

#include <adept/tagfilter.h>
#include <adept/taglist.h>

using namespace adept;

TagFilterWidget::TagFilterWidget( QWidget *w, const char *n )
    : TagFilterUi( w, n )
{
    m_wanted->setName( i18n( "Tags I Want (drop tags here)" ) );
    m_unwanted->setName( i18n( "Tags I Do Not Want (drop tags here)" ) );

    connect( m_wanted, SIGNAL( tagsChanged( TagList::Tag::Set ) ),
             this, SLOT( wantedChanged() ) );
    connect( m_unwanted, SIGNAL( tagsChanged( TagList::Tag::Set ) ),
             this, SLOT( unwantedChanged() ) );
}

TagFilterWidget::Predicate TagFilterWidget::predicate()
{
    TagFilter< entity::Package > f;
    f.setWanted( m_wanted->tags() );
    f.setUnwanted( m_unwanted->tags() );
    return predicate::adapt< entity::Entity >( f );
}

static void setTagsBlocking( TagList *l, TagList::Tag::Set s ) {
    l->blockSignals( true );
    l->setTags( s );
    l->blockSignals( false );
}

void TagFilterWidget::predicateChanged()
{
    typedef TagFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    setTagsBlocking( m_wanted, f.wanted() );
    setTagsBlocking( m_unwanted, f.unwanted() );
    if ( item() && item()->list() ) {
        setupColors();
        item()->list()->delayedUpdateExtenders();
    }
}

void TagFilterWidget::wantedChanged()
{
    setTagsBlocking( m_unwanted, m_unwanted->tags() - m_wanted->tags() );
    setupColors();
    widgetsChanged();
    item()->list()->delayedUpdateExtenders();
}

void TagFilterWidget::unwantedChanged()
{
    setTagsBlocking( m_wanted, m_wanted->tags() - m_unwanted->tags() );
    setupColors();
    widgetsChanged();
    item()->list()->delayedUpdateExtenders();
}
