#!/bin/sh

. /etc/default/acpi-support
. /usr/share/acpi-support/power-funcs

getState;

checkStateChanged;

grep -q off-line /proc/acpi/ac_adapter/*/state
if [ $? = 0 ] && [ x$1 != xstop ]; then
    
    if [ x$ENABLE_LAPTOP_MODE = xtrue ]; then
	$LAPTOP_MODE start

	if [ -d /sys/bus/ide ]; then
	    for x in /sys/bus/ide/devices/*/block; do 
		drive=$(basename $(readlink $x));
		$HDPARM -S 12 /dev/$drive
		#$HDPARM -B 1 /dev/$drive
	    done
	fi

#	if [ -d /sys/bus/scsi ]; then
#	    for x in /sys/bus/scsi/devices/*/block; do 
#		drive=$(basename $(readlink $x));
#		$HDPARM -S 12 /dev/$drive
#		#$HDPARM -B 1 /dev/$drive
#	    done
#	fi
    fi
    
    for x in /tmp/.X11-unix/*; do
	displaynum=`echo $x | sed s#/tmp/.X11-unix/X##`
	getXuser;
	if [ x"$XAUTHORITY" != x"" ]; then		
	    export DISPLAY=":$displaynum"
	    su $user -c "xscreensaver-command -throttle" &
	    xset dpms 0 0 120
	fi
    done
else
    if [ x$ENABLE_LAPTOP_MODE = xtrue ]; then
	if [ -d /sys/bus/ide ]; then
	    for x in /sys/bus/ide/devices/*/block; do 
		drive=$(basename $(readlink $x));
		$HDPARM -S 0 /dev/$drive
		#$HDPARM -B 255 /dev/$drive
	    done
	fi
#	if [ -d /sys/bus/scsi ]; then
#	    for x in /sys/bus/scsi/devices/*/block; do 
#		drive=$(basename $(readlink $x));
#		$HDPARM -S 0 /dev/$drive
#		#$HDPARM -B 255 /dev/$drive
#	    done
#	fi
	$LAPTOP_MODE stop
    fi

    for x in /tmp/.X11-unix/*; do
	displaynum=`echo $x | sed s#/tmp/.X11-unix/X##`
	getXuser;
	if [ x"$XAUTHORITY" != x"" ]; then		
	    export DISPLAY=":$displaynum"
	    su $user -c "xscreensaver-command -unthrottle" &
	    xset dpms 0 0 600
	fi
    done
fi
