#!/bin/bash

# Post the video card
if [ x$POST_VIDEO = xtrue ]; then
  vbetool post
fi

# Attempt to restore some video card state
if [ x$SAVE_VBE_STATE = xtrue ]; then
  vbetool vbestate restore <$VBESTATE
fi

# Load any drivers that we removed
for x in $MODULES; do
    modprobe $x;
done

# Get PCMCIA cards back
cardctl insert

#run ifrename so that the interfaces are the same as previously
ifrename

# Bring up the interfaces (this should probably be left up to some policy
# manager, but at the moment we just bring back whatever we ifdowned)
#for x in $INTERFACES; do
#    ifup $x;
#done

# Actually, we don't for the moment - we end up waiting for things to time out
# because multiple ifups want to write to the state file and it's locked. We
# need a better way of doing this - for now just bring back up whatever is
# flagged as auto

ifup -a &

# Reset the time
hwclock --hctosys

# And make sure that the screen is on
if [ x$USE_DPMS = xtrue ]; then
  vbetool dpms on
fi

# Some hardware needs another X/console switch in order to bring stuff back
chvt $CONSOLE;
if [ x$DOUBLE_CONSOLE_SWITCH = xtrue ]; then
  chvt 12;
  chvt $CONSOLE;
fi

# now, we should poke xscreensaver so you get a dialog
su $user -c "(xscreensaver-command -deactivate)"

# we need to restart our services after the network is back
for x in $STOP_SERVICES; do
        invoke-rc.d --quiet $x start
done

# Some hardware gets unhappy about button events unless we do this
rmmod button
modprobe button

#Let acpid process events again
(sleep 1 && rm /var/lock/acpid)&
