#!/bin/bash

#prevent acpid from processing any following events
touch /var/lock/acpid

# Find the currently running network interfaces...
INTERFACES=`/sbin/ifconfig | awk '/^[^ ]+/ {print $1}'`

# And shut them down
for x in $INTERFACES; do
    ifdown $x;
    ifconfig $x down;
done

# This is not guaranteed to work - several drivers appear to use names that
# are not the same as their module name
for x in /sys/class/net/*; do
    if [ -e $x/driver ]
	then
	MODULES="$MODULES `readlink $x/driver | awk -F/ '{print $7}' | tr [:upper:] [:lower:]`"
    fi
done

# Now do something similar for USB
for x in /sys/class/usb_host/*; do
    if [ -e $x/driver ]
	then
	MODULES="$MODULES `readlink $x/driver | awk -F/ '{print $7}' | tr [:upper:] [:lower:]`"
    fi
done

# Now remove various modules that might misbehave while suspending
for x in $MODULES; do
    rmmod $x 2>/dev/null;
done

# Unload PCMCIA cards
cardctl eject

# And remember which console we're on
CONSOLE=`fgconsole`

# Change away from X, otherwise it'll blow up when we POST the video interface
chvt 12

# Shut down services known to misbehave
for x in $STOP_SERVICES; do
        invoke-rc.d --quiet $x stop
done

# And then try to save some video state
#if [ x$SAVE_VBE_STATE = "xtrue" ]; then
#  VBESTATE=`tempfile`
#  vbetool vbestate save >$VBESTATE;
#fi

# Make sure the backlight goes off
if [ x$USE_DPMS = "xtrue" ]; then
  vbetool dpms off
fi
