Description: Fix memory leaks in act-user.c
 Caller must free all of the values returned by g_variant_iter_next()
Bug: https://bugs.freedesktop.org/show_bug.cgi?id=51039
Origin: upstream, commit:279a6e0dfaffd6d8aa8363
---
 src/libaccountsservice/act-user.c |    4 +++-
 1 file changed, 3 insertions(+), 1 deletion(-)

Index: accountsservice-0.6.21/src/libaccountsservice/act-user.c
===================================================================
--- accountsservice-0.6.21.orig/src/libaccountsservice/act-user.c	2012-07-19 21:10:25.936388687 +0200
+++ accountsservice-0.6.21/src/libaccountsservice/act-user.c	2012-07-19 21:10:35.532388754 +0200
@@ -1230,7 +1230,7 @@
         GError      *error;
         GVariant    *res;
         GVariantIter *iter;
-        const gchar *key;
+        gchar *key;
         GVariant    *value;
 
         g_assert (G_IS_DBUS_PROXY (user->object_proxy));
@@ -1256,6 +1256,8 @@
         g_variant_get (res, "(a{sv})", &iter);
         while (g_variant_iter_next (iter, "{sv}", &key, &value)) {
                 collect_props (key, value, user);
+                g_free (key);
+                g_variant_unref (value);
         }
         g_variant_iter_free (iter);
         g_variant_unref (res);
