/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiWord
 * Copyright (C) 2003 Francis James Franklin <fjf@alinameridon.com>
 * Copyright (C) 2003 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#include <stdlib.h>

#include "ut_CSS.h"

static const char * CSSPropertyName[UT_CSS::css__count__] = {
	"azimuth",
	"background-attachment",
	"background-color",
	"background-image",
	"background-position",
	"background-repeat",
	"background",
	"border-collapse",
	"border-color",
	"border-spacing",
	"border-style",
	"border-top",
	"border-right",
	"border-bottom",
	"border-left",
	"border-top-color",
	"border-right-color",
	"border-bottom-color",
	"border-left-color",
	"border-top-style",
	"border-right-style",
	"border-bottom-style",
	"border-left-style",
	"border-top-width",
	"border-right-width",
	"border-bottom-width",
	"border-left-width",
	"border-width",
	"border",
	"bottom",
	"caption-side",
	"clear",
	"clip",
	"color",
	"content",
	"counter-increment",
	"counter-reset",
	"cue-after",
	"cue-before",
	"cue",
	"cursor",
	"direction",
	"display",
	"elevation",
	"empty-cells",
	"float",
	"font-family",
	"font-size",
	"font-style",
	"font-variant",
	"font-weight",
	"font",
	"height",
	"left",
	"letter-spacing",
	"line-height",
	"list-style-image",
	"list-style-position",
	"list-style-type",
	"list-style-type",
	"list-style",
	"margin-right",
	"margin-left",
	"margin-top",
	"margin-bottom",
	"margin",
	"max-height",
	"max-width",
	"min-height",
	"min-width",
	"orphans",
	"outline-color",
	"outline-style",
	"outline-width",
	"outline",
	"overflow",
	"padding-top",
	"padding-right",
	"padding-bottom",
	"padding-left",
	"padding",
	"page-break-after",
	"page-break-before",
	"page-break-inside",
	"pause-after",
	"pause-before",
	"pause",
	"pitch-range",
	"pitch",
	"play-during",
	"position",
	"quotes",
	"richness",
	"right",
	"speak-header",
	"speak-numeral",
	"speak-punctuation",
	"speak",
	"speech-rate",
	"stress",
	"table-layout",
	"text-align",
	"text-align",
	"text-decoration",
	"text-indent",
	"text-transform",
	"top",
	"unicode-bidi",
	"vertical-align",
	"visibility",
	"voice-family",
	"volume",
	"white-space",
	"widows",
	"width",
	"word-spacing",
	"z-index"
};

const char * UT_CSS::css_property_name (CSSPropertyIndex index)
{
	return (index < css__count__) ? CSSPropertyName[index] : 0;
}

extern "C" {
	static int s_str_compare (const void * a, const void * b)
	{
		const char *         pea = reinterpret_cast<const char *>(a);
		const char * const * pod = reinterpret_cast<const char * const *>(b);

		return strcmp (pea, *pod);
	}
}

bool UT_CSS::css_property_lookup (const char * name, CSSPropertyIndex & index);
{
	if ( name == 0) return false;
	if (*name == 0) return false;

	void * result = bsearch (name, CSSPropertyName,
							 static_cast<size_t>(css__count__), sizeof (char *), s_str_compare);

	if (result == 0) return false;

	const char * const * css_name = reinterpret_cast<const char * const *>(result);

	index = static_cast<CSSPropertyIndex>(css_name - CSSPropertyName);

	return true;
}

void UT_CSS::css_parse_style_attr (const char * style, Listener * listener)
{
	if (listener == 0) return;

	if ( style == 0) return;
	if (*style == 0) return;

	// 
}
